
/* i2c hardware, master függvénytár*/


#include <inttypes.h>
#include <compat/twi.h>

#define CPUFREQ 4000000UL
#define BUSCLOCK  100000L


void i2cInit(void)
{
  /* initialize TWI clock: 100 kHz clock, TWPS = 0 => prescaler = 1 */
  
  TWSR = 0;                         /* nincs előosztó */
  TWBR = ((CPUFREQ/BUSCLOCK)-16)/2;  /* ha nagyobb mint 10 akkor stabil */

}


unsigned char i2cStart(unsigned char cim)
{
    	uint8_t   twst;

	
	TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
	while(!(TWCR & (1<<TWINT)));

	twst = TW_STATUS & 0xF8;
	if ( (twst != TW_START) && (twst != TW_REP_START)) return 1;

	TWDR = cim;
	TWCR = (1<<TWINT) | (1<<TWEN);

	while(!(TWCR & (1<<TWINT)));

	twst = TW_STATUS & 0xF8;
	if ( (twst != TW_MT_SLA_ACK) && (twst != TW_MR_SLA_ACK) ) return 1;

	return 0;
}


void i2cSwait(unsigned char cim)
{
	uint8_t   twst;


    	while ( 1 )
    	{
		TWCR = (1<<TWINT) | (1<<TWSTA) | (1<<TWEN);
    
   	 	while(!(TWCR & (1<<TWINT)));
    
    		twst = TW_STATUS & 0xF8;
    		if ( (twst != TW_START) && (twst != TW_REP_START)) continue;
    
   	 	TWDR = cim;
    		TWCR = (1<<TWINT) | (1<<TWEN);
    
   	 	while(!(TWCR & (1<<TWINT)));
    
    		twst = TW_STATUS & 0xF8;
    		if ( (twst == TW_MT_SLA_NACK )||(twst ==TW_MR_DATA_NACK) ) 
    	{    	    
	        TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWSTO);
	        while(TWCR & (1<<TWSTO));	        
    	    	continue;
    	}
    	break;
     }
}


unsigned char i2cRestart(unsigned char cim)
{
    	return i2cStart( cim );
}

void i2cStop(void)
{
	TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWSTO);
	while(TWCR & (1<<TWSTO));
}


unsigned char i2cWrite( unsigned char adat )
{	
	uint8_t   twst;
 
	TWDR = adat;
	TWCR = (1<<TWINT) | (1<<TWEN);
	while(!(TWCR & (1<<TWINT)));

	twst = TW_STATUS & 0xF8;
	if( twst != TW_MT_DATA_ACK) return 1;
	return 0;
}


unsigned char i2cRead(unsigned char ack)
{
	if (ack)
	{
		TWCR = (1<<TWINT) | (1<<TWEN) | (1<<TWEA);
		while(!(TWCR & (1<<TWINT)));    
    		return TWDR;
	}
	else
	{
		TWCR = (1<<TWINT) | (1<<TWEN);
		while(!(TWCR & (1<<TWINT)));
		return TWDR;
	}
	
}

void i2cSend(unsigned char hw_cim,unsigned int cim, unsigned char adat)
{
	i2cStart(hw_cim);
	i2cWrite((char) cim >> 8);
	i2cWrite((char) cim & 0x00ff);
	//i2cWrite(cim ); //ha  az eeprom belső címe csak 8 bit :) 24LC16 - tól vissza
	i2cWrite( adat );
	i2cStop();
	delay_1ms(1);	
}


unsigned char i2cRec(unsigned char hw_cim,unsigned int cim)
{
	unsigned char retval;
	i2cStart(hw_cim);
	i2cWrite((char) cim >> 8);
	i2cWrite((char) cim & 0x00ff);
	i2cRestart(hw_cim |= 1);
	retval = i2cRead(0);
	i2cStop();
	delay_1ms(1);
	return retval;
};